/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser;

import java.io.Serializable;
import java.util.Collection;
import org.jrubyparser.ast.CommentNode;
import org.jrubyparser.ast.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePosition
implements Serializable {
    private static final long serialVersionUID = 3762529027281400377L;
    private final String file;
    private final int startLine;
    private final int endLine;
    private int startOffset;
    private final int endOffset;
    private Collection<CommentNode> comments = Node.EMPTY_COMMENT_LIST;
    public static final SourcePosition INVALID_POSITION = new SourcePosition(){

        @Override
        public String getFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void adjustStartOffset(int relativeValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public SourcePosition union(SourcePosition position) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CommentNode> getComments() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setComments(Collection<CommentNode> comments) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };

    public SourcePosition() {
        this("", 0, 0);
    }

    public SourcePosition(String file, int startLine, int endLine) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = 0;
        this.endOffset = 0;
    }

    public SourcePosition(String file, int startLine, int endLine, int startOffset, int endOffset) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.file = file;
        this.startLine = startLine;
        this.endLine = endLine;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public String getFile() {
        return this.file;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SourcePosition)) {
            return false;
        }
        SourcePosition other = (SourcePosition)object;
        return this.file.equals(other.file) && this.endLine == other.endLine;
    }

    public int hashCode() {
        return this.file.hashCode() ^ this.endLine;
    }

    public String toString() {
        return String.valueOf(this.file) + ":[" + this.startLine + "," + this.endLine + "]:[" + this.getStartOffset() + "," + this.getEndOffset() + "]";
    }

    public void adjustStartOffset(int relativeValue) {
        this.startOffset += relativeValue;
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public SourcePosition union(SourcePosition other) {
        return new SourcePosition(this.file, this.startLine, other.getEndLine(), this.startOffset, other.getEndOffset());
    }

    public static SourcePosition combinePosition(SourcePosition firstPos, SourcePosition secondPos) {
        String fileName = firstPos.getFile();
        int startOffset = firstPos.getStartOffset();
        int endOffset = firstPos.getEndOffset();
        int startLine = firstPos.getStartLine();
        int endLine = firstPos.getEndLine();
        if (startOffset > secondPos.getStartOffset()) {
            startOffset = secondPos.getStartOffset();
            startLine = secondPos.getStartLine();
        }
        if (endOffset < secondPos.getEndOffset()) {
            endOffset = secondPos.getEndOffset();
            endLine = secondPos.getEndLine();
        }
        SourcePosition combinedPosition = new SourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        return combinedPosition;
    }

    public Collection<CommentNode> getComments() {
        return this.comments;
    }

    public void setComments(Collection<CommentNode> comments) {
        this.comments = comments;
    }
}

